#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

float Matrix[16];

#define FOND_Z (1.f)
static GrVertex Flare1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Flare2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Flare3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Flare4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static float TabX[] = {200,300,375,450};

void LInit_Scorpzoom()
{
	PrepareTextureFromArray(g_PicScorpion, 256, 256, &g_TextureScorpion);
	PrepareTextureFromArray(g_PicFlareVert, 256, 256, &g_TextureFlareVert);
}

void QInit_Scorpzoom()
{
  grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
  grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
  grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
		       GR_BLEND_ONE, GR_BLEND_ZERO);
  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
  grCullMode(GR_CULL_DISABLE);
  
  grChromakeyMode(GR_CHROMAKEY_DISABLE);
  grFogMode(GR_FOG_DISABLE);

  DownloadTexture(&g_TextureScorpion);
  DownloadTexture(&g_TextureFlareVert);
}

void DrawFlareVert(float x, float y, float fTime)
{
	float fSize;
	DWORD dwTmp;

	SelectTexture(g_TextureFlareVert);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_LOCAL,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	fSize = fTime*640.f/(5000/4);
	Flare1.x = x - fSize;
	Flare2.x = x + fSize;
	Flare3.x = x + fSize;
	Flare4.x = x - fSize;

	Flare1.y = y - fSize;
	Flare2.y = y - fSize;
	Flare3.y = y + fSize;
	Flare4.y = y + fSize;

	//dwTmp = 256-fTime*256/(5000/4);
	dwTmp = 256-fTime*280/(5000/4);
	dwTmp = CLIP_DW(dwTmp);
	grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));

	guDrawTriangleWithClip(&Flare1, &Flare2, &Flare3);			
	guDrawTriangleWithClip(&Flare3, &Flare4, &Flare1);
}

void Effect_Scorpzoom()
{
	DWORD dwTmp;

	dwTmp = (g_demostate.TickInEffect+250)/(5000/4);
	if ((dwTmp>0)&&(dwTmp<5))
		DrawFlareVert(TabX[dwTmp-1],240, (g_demostate.TickInEffect+250)%(5000/4));
	if (dwTmp==4)
	{
		grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
			 GR_COMBINE_FACTOR_ONE,
			 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = (g_demostate.TickInEffect+250)%(5000/4);
		dwTmp = dwTmp * 280 / (5000/4);
		dwTmp = CLIP_DW(dwTmp);
		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
		grDrawTriangle(&Fond1, &Fond2, &Fond3);
		grDrawTriangle(&Fond3, &Fond4, &Fond1);
	}
	SelectTexture(g_TextureScorpion);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	// map : 11 <-> 245 => maplen == 234
	// spritelen == 320*4 == 1280
	// SC -> 61 -> 1280*61/234 == 334 | 0
	// OR -> 66 -> 1280*66/234 == 361 | 334/2 + 361/2 = 347
	// PI -> 41 -> 1280*41/234 == 224 | 334/2 + 361 + 224/2 = 640
	// ON -> 66 -> 1280*66/234 == 361 | 334/2 + 361 + 224 + 361/2 = 932

	if (g_demostate.TickInEffect<5000/4) // SC
	{
		BeIdentityMatrix(Matrix);
		TranslateMatrix(Matrix, -473+50, -50, 10+g_demostate.TickInEffect);
		Draw3dSpriteEx(334/2, 120, 11,0, 73,40, Matrix);
	}
	else
	{
		BeIdentityMatrix(Matrix);
		TranslateMatrix(Matrix, -473+50, -50, 10+5000/4);
		Draw3dSpriteEx(334/2, 120, 11,0, 73,40, Matrix);

		if (g_demostate.TickInEffect<5000/4*2) // OR
		{
			BeIdentityMatrix(Matrix);
			TranslateMatrix(Matrix, 347-473+50, -50, 10+g_demostate.TickInEffect-5000/4);
			Draw3dSpriteEx(361/2, 120, 73,0, 139,40, Matrix);
		}
		else
		{
			BeIdentityMatrix(Matrix);
			TranslateMatrix(Matrix, 347-473+50, -50, 10+5000/4);
			Draw3dSpriteEx(361/2, 120, 73,0, 139,40, Matrix);

			if (g_demostate.TickInEffect<5000/4*3) // PI
			{
				BeIdentityMatrix(Matrix);
				TranslateMatrix(Matrix, 640-473+50, -50, 10+g_demostate.TickInEffect-5000/4*2);
				Draw3dSpriteEx(224/2, 120, 139,0, 180,40, Matrix);
			}
			else
			{
				BeIdentityMatrix(Matrix);
				TranslateMatrix(Matrix, 640-473+50, -50, 10+5000/4);
				Draw3dSpriteEx(224/2, 120, 139,0, 180,40, Matrix);

				if (g_demostate.TickInEffect<5000/4*4) // ON
				{
					BeIdentityMatrix(Matrix);
					TranslateMatrix(Matrix, 932-473+50, -50, 10+g_demostate.TickInEffect-5000/4*3);
					Draw3dSpriteEx(361/2, 120, 180,0, 246,40, Matrix);
				}
				else
				{
					BeIdentityMatrix(Matrix);
					TranslateMatrix(Matrix, 932-473+50, -50, 10+5000/4);
					Draw3dSpriteEx(361/2, 120, 180,0, 246,40, Matrix);
				}
			}
		}
	}
}

void ByeBye_Scorpzoom()
{
	FreeTexture(&g_TextureFlareVert);
	FreeTexture(&g_TextureScorpion);
}
